<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Genesis Menu.
 *
 * @since 3.0.0
 */
class Genesis_Menu {

	/**
	 * Name of the active theme.
	 *
	 * @var string
	 */
	protected $theme_name;

	/**
	 * Array of script configurations parameters.
	 *
	 * @var array
	 */
	protected $config;

	/**
	 * Holds script file name suffix.
	 *
	 * @var string suffix
	 */
	private $suffix = '.min';

	/**
	 * Responsive menu script version.
	 *
	 * @var string
	 */
	const SCRIPT_VERSION = '1.1.3';

	/**
	 * Genesis_Responsive_Menu_Handler constructor.
	 *
	 * @since 3.0.0
	 *
	 * @param string $theme_name Name of the active theme.
	 * @param array  $config     Array of configurations parameters.
	 */
	public function __construct( $theme_name, array $config ) {

		$this->theme_name = $theme_name;
		$this->config     = $config;

		if ( isset( $this->config['menuIconOpenedClass'] ) ) {
			unset( $this->config['menuIconOpenedClass'] );
		}

	}

	/**
	 * Hook into WordPress.
	 *
	 * @since 3.0.0
	 */
	public function add_hooks() {

		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

	}

	/**
	 * Enqueues scripts.
	 */
	public function enqueue_scripts() {

		if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) {
			$this->suffix = '';
		}

		wp_enqueue_script(
			"{$this->theme_name}-responsive-menu",
			GENESIS_JS_URL . "/menu/responsive-menus{$this->suffix}.js",
			[ 'jquery' ],
			self::SCRIPT_VERSION,
			true
		);

		wp_localize_script(
			"{$this->theme_name}-responsive-menu",
			'genesis_responsive_menu',
			$this->config
		);

	}

}
